/*----------------------------------------------------------------------------

 Copyright (C) Sartorius Stedim Data Analytics AB 2017 -

 Use, modification and distribution are subject to the Boost Software
 License, Version 1.0. (See http://www.boost.org/LICENSE_1_0.txt)

----------------------------------------------------------------------------*/

#include "utf8util.h"
#ifdef _WIN32
#include <Windows.h>
#endif

#include <stdio.h>

#ifdef _WIN32

char* ActiveCPToUTF8(char* instr)
{
   int iWideLen;
   wchar_t* utf16str;
   char* utf8str;
   int iNeedSize;

   iWideLen = MultiByteToWideChar(CP_ACP, 0, instr, -1, NULL, 0);

   utf16str = (wchar_t*)malloc(sizeof(wchar_t)*iWideLen);
   if (utf16str == NULL)
      return NULL;

   MultiByteToWideChar(CP_ACP, 0, instr, -1, utf16str, iWideLen);

   /* Convert the UTF-16 argument to UTF-8 */
   iNeedSize = WideCharToMultiByte(CP_UTF8, 0, utf16str, iWideLen, NULL, 0, NULL, NULL);
   utf8str = (char*)malloc(iNeedSize);
   WideCharToMultiByte(CP_UTF8, 0, utf16str, iWideLen, utf8str, iNeedSize, NULL, NULL);
   return utf8str;
}

char* UTF8toActiveCP(char* instr)
{
   int iWideLen;
   wchar_t* utf16str;
   char* acpstr;
   int iNeedSize;

   iWideLen = MultiByteToWideChar(CP_UTF8, 0, instr, -1, NULL, 0);

   utf16str = (wchar_t*)malloc(sizeof(wchar_t)*iWideLen);
   if (utf16str == NULL)
      return NULL;

   MultiByteToWideChar(CP_UTF8, 0, instr, -1, utf16str, iWideLen);

   /* Convert the UTF-16 argument to UTF-8 */
   iNeedSize = WideCharToMultiByte(CP_ACP, 0, utf16str, iWideLen, NULL, 0, NULL, NULL);
   acpstr = (char*)malloc(iNeedSize);
   WideCharToMultiByte(CP_ACP, 0, utf16str, iWideLen, acpstr, iNeedSize, NULL, NULL);
   return acpstr;
}


char* UTF16toUTF8(wchar_t* instr)
{
   char* utf8Arg;
   int iNeedSize;

   /* Convert the UTF-16 argument to UTF-8 */
   iNeedSize = WideCharToMultiByte(CP_UTF8, 0, instr, -1, NULL, 0, NULL, NULL);
   if (iNeedSize == 0)
      return NULL;
   utf8Arg = (char*)malloc(iNeedSize);
   WideCharToMultiByte(CP_UTF8, 0, instr, -1, utf8Arg, iNeedSize, NULL, NULL);

   return utf8Arg;
}

wchar_t* UTF8toUTF16(char* instr)
{
   int iWideLen;
   wchar_t* utf16str;

   iWideLen = MultiByteToWideChar(CP_UTF8, 0, instr, -1, NULL, 0);

   utf16str = (wchar_t*)malloc(sizeof(wchar_t)*iWideLen);
   if (utf16str == NULL)
      return NULL;

   MultiByteToWideChar(CP_UTF8, 0, instr, -1, utf16str, iWideLen);
   return utf16str;
}

#ifdef _UNICODE

void PrintUTF8String(FILE* file, char* szString)
{
   wchar_t* utf16str = UTF8toUTF16(szString);
   fwprintf(file, L"%s", utf16str);
   free(utf16str);
}


void UTF8_vprintf(FILE* file, char* fmt, va_list ap)
{
   int cnt, sz = 0;
   char* buf;
   wchar_t* wcs;

   sz = 512;
   buf = (char*)_alloca(sz);
try_print:
   cnt = vsnprintf(buf, sz, fmt, ap);
   if (cnt >= sz) 
   {
      buf = (char*)_alloca(cnt - sz + 1);
      sz = cnt + 1;
      goto try_print;
   }

   wcs = UTF8toUTF16(buf);
   fwprintf(file, L"%s", wcs);
   free(wcs);
}


void UTF8_printf(FILE* file, char *fmt, ...)
{
   va_list args;

   va_start(args, fmt);

   UTF8_vprintf(file, fmt, args);

   va_end(args);
}

char* TCHARtoUTF8(TCHAR* instr)
{
   return UTF16toUTF8(instr);
}

TCHAR* UTF8toTCHAR(char* instr)
{
   return UTF8toUTF16(instr);
}

#else

void PrintUTF8String(FILE* file, char* szString)
{
   char* actstr = UTF8toActiveCP(szString);
   fprintf(file, actstr);
   free(actstr);
}

void UTF8_vprintf(FILE* file, char* fmt, va_list ap)
{
   int cnt, sz = 0;
   char* buf;
   char* cs;

   sz = 512;
   buf = (char*)_alloca(sz);
try_print:
   cnt = vsnprintf(buf, sz, fmt, ap);
   if (cnt >= sz)
   {
      buf = (char*)_alloca(cnt - sz + 1);
      sz = cnt + 1;
      goto try_print;
   }

   cs = UTF8toActiveCP(buf);
   fprintf(file, "%s", cs);
   free(cs);
}


void UTF8_printf(FILE* file, char *fmt, ...)
{
   va_list args;

   va_start(args, fmt);

   UTF8_vprintf(file, fmt, args);

   va_end(args);
}

char* TCHARtoUTF8(TCHAR* instr)
{
   return ActiveCPToUTF8(instr);
}

TCHAR* UTF8toTCHAR(char* instr)
{
   return UTF8toActiveCP(instr);
}

#endif /* _UNICODE */

#else

void PrintUTF8String(FILE* file, char* szString)
{
   fprintf(file, szString);
}

#endif
